<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'UserController::index');

// admin
$routes->get('admin', 'LoginAdminController::index');
$routes->get('admin/dashboard', 'AdminController::dashboard', ['filter' => 'auth']);
$routes->get('admin/vacancies', 'AdminController::vacancies', ['filter' => 'auth']);
$routes->get('admin/companies', 'AdminController::companies', ['filter' => 'auth']);
$routes->get('admin/applicant', 'AdminController::applicant', ['filter' => 'auth']);
$routes->get('admin/users', 'AdminController::users', ['filter' => 'auth']);
$routes->get('admin/profile', 'AdminController::profile', ['filter' => 'auth']);
$routes->get('admin/login', 'LoginAdminController::index', ['filter' => 'auth']);
$routes->get('admin/logout', 'LoginAdminController::logout', ['filter' => 'auth']);
$routes->get('admin/verify_users', 'AdminController::checkUsers', ['filter' => 'auth']);
$routes->get('admin/verify_companies', 'AdminController::checkCompanies', ['filter' => 'auth']);
$routes->get('admin/activate_user/(:segment)', 'AdminController::activateUser/$1', ['filter' => 'auth']);
$routes->get('admin/disable_user/(:segment)', 'AdminController::disableUser/$1', ['filter' => 'auth']);
$routes->get('admin/activate_company/(:segment)', 'AdminController::activateCompany/$1', ['filter' => 'auth']);
$routes->get('admin/disable_company/(:segment)', 'AdminController::disableCompany/$1', ['filter' => 'auth']);

$routes->get('admin/company-sector', 'CompanySectorController::index', ['filter' => 'auth']);
$routes->get('admin/company-sector/create', 'CompanySectorController::create', ['filter' => 'auth']);
$routes->post('admin/company-sector/store', 'CompanySectorController::store', ['filter' => 'auth']);
$routes->get('admin/company-sector/edit/(:any)', 'CompanySectorController::edit/$1', ['filter' => 'auth']);
$routes->post('admin/company-sector/update/(:any)', 'CompanySectorController::update/$1', ['filter' => 'auth']);
$routes->get('admin/company-sector/delete/(:any)', 'CompanySectorController::delete/$1', ['filter' => 'auth']);

$routes->get('admin/company-interest', 'CompanyInterestController::index', ['filter' => 'auth']);
$routes->get('admin/company-interest/create', 'CompanyInterestController::create', ['filter' => 'auth']);
$routes->post('admin/company-interest/store', 'CompanyInterestController::store', ['filter' => 'auth']);
$routes->get('admin/company-interest/edit/(:any)', 'CompanyInterestController::edit/$1', ['filter' => 'auth']);
$routes->post('admin/company-interest/update/(:any)', 'CompanyInterestController::update/$1', ['filter' => 'auth']);
$routes->get('admin/company-interest/delete/(:any)', 'CompanyInterestController::delete/$1', ['filter' => 'auth']);

$routes->get('admin/skills', 'CompanySkillController::index', ['filter' => 'auth']);
$routes->get('admin/skills/create', 'CompanySkillController::create', ['filter' => 'auth']);
$routes->post('admin/skills/store', 'CompanySkillController::store', ['filter' => 'auth']);
$routes->get('admin/skills/edit/(:any)', 'CompanySkillController::edit/$1', ['filter' => 'auth']);
$routes->post('admin/skills/update/(:any)', 'CompanySkillController::update/$1', ['filter' => 'auth']);
$routes->get('admin/skills/delete/(:any)', 'CompanySkillController::delete/$1', ['filter' => 'auth']);

$routes->post('admin/login/auth', 'LoginAdminController::auth');

// company
$routes->get('company/login', 'LoginController::index');
$routes->get('company/logout', 'LoginController::logout');
$routes->get('/company', 'DashboardController::companyLogin');
$routes->get('/company/template/topbar', 'DashboardController::profil');
$routes->get('company/vacancy/edit/(:segment)', 'DashboardController::edit/$1', ['filter' => 'auth']);
$routes->get('company/vacancy/delete/(:segment)', 'DashboardController::hapusVacancy/$1');
$routes->get('company/addvacancy', 'DashboardController::showAddVacancyForm', ['filter' => 'auth']);
$routes->get('company/vacancies/applicants/(:segment)', 'DashboardController::applicants/$1', ['filter' => 'auth']);
$routes->get('company/vacancies', 'DashboardController::vacancies', ['filter' => 'auth']);
$routes->get('company/vacancies/acceptApplicant/(:any)/(:any)/(:any)', 'DashboardController::acceptApplicant/$1/$2/$3', ['filter' => 'auth']);
$routes->get('company/vacancies/rejectApplicant/(:any)/(:any)/(:any)', 'DashboardController::rejectApplicant/$1/$2/$3', ['filter' => 'auth']);
$routes->post('company/vacancies/handleApplicant/(:any)/(:any)/(:any)', 'DashboardController::handleApplicant/$1/$2/$3', ['filter' => 'auth']);

$routes->get('company/vacancy/edit/(:segment)', 'DashboardController::edit/$1');
$routes->get('company/dashboard', 'DashboardController::index', ['filter' => 'auth']);
$routes->get('company/applicant', 'DashboardController::vacancyApplicant', ['filter' => 'auth']);
$routes->get('company/profile', 'DashboardController::company', ['filter' => 'auth']);
$routes->get('/company/edit/(:segment)', 'DashboardController::editProfile/$1', ['filter' => 'auth']);
$routes->get('company/register', 'DashboardController::registerCompany');

$routes->post('company/register/submit', 'DashboardController::submitCompanyRegister');
$routes->post('company/addvacancy', 'DashboardController::addVacancy');
$routes->post('company/vacancy/update/(:segment)', 'DashboardController::update/$1');
$routes->post('company/vacancy/update/(:segment)', 'DashboardController::update/$1');
$routes->post('company/login/auth', 'LoginController::auth');
$routes->post('/company/update/(:segment)', 'DashboardController::updateProfile/$1');
$routes->post('/company/upload-logo/(:segment)', 'DashboardController::uploadLogo/$1');
$routes->post('company/upload-akta/(:segment)', 'DashboardController::uploadAkta/$1');


// users
$routes->get('dashboard', 'UserController::dashboard');
$routes->get('dashboard', 'UserController::profile');
$routes->get('login', 'UserController::index');
$routes->get('logout', 'UserController::logout');
$routes->get('profile', 'UserController::profile', ['filter' => 'auth']);
$routes->get('user/edit/(:segment)', 'UserController::editProfile/$1');
$routes->get('vacancies', 'UserController::vacancies', ['filter' => 'auth']);
$routes->get('popular', 'UserController::popular', ['filter' => 'auth']);
$routes->get('status', 'UserController::applyStatus', ['filter' => 'auth']);
$routes->get('tes/(:segment)', 'UserController::tes/$1');
$routes->get('detail_vacancy/(:segment)', 'UserController::detail_vacancy/$1', ['filter' => 'auth']);
$routes->get('detail_vacancy_with_company/(:segment)', 'UserController::detail_vacancy_with_company/$1', ['filter' => 'auth']);

$routes->get('apply/(:segment)/(:segment)', 'UserController::applyJobs/$1/$2', ['filter' => 'auth']);
$routes->get('jobs/recommend', 'UserController::recommendJobs', ['filter' => 'auth']);
$routes->get('register', 'UserController::registerUser');

$routes->post('user/update/(:segment)', 'UserController::updateProfile/$1');
$routes->post('user/upload-logo/(:segment)', 'UserController::uploadPhoto/$1');
$routes->post('user/upload-cv/(:segment)', 'UserController::uploadcv/$1');
$routes->post('register/submit', 'UserController::submitUserRegister');
$routes->post('login/auth', 'UserController::auth');

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
