<?php

namespace App\Controllers;

use App\Models\InterestModel;
use CodeIgniter\Controller;

class CompanyInterestController extends Controller
{
    public function index()
    {
        $judul = [
            'title' => 'Minat',
        ];
        $model = new InterestModel();
        $data['interest'] = $model->getInterest();

        return view('admin/company_interest/index', array_merge($data, $judul));
    }

    public function create()
    {
        $judul = [
            'title' => 'Minat',
        ];
        return view('admin/company_interest/create', $judul);
    }

    public function store()
    {
        $model = new InterestModel();

        $data = [
            'name' => $this->request->getVar('name')
        ];

        $model->save($data);

        return redirect()->to('/admin/company-interest');
    }

    public function edit($id)
    {
        $judul = [
            'title' => 'Interest Perusahaan',
        ];
        $model = new InterestModel();
        $data['interest'] = $model->find($id);

        return view('admin/company_interest/edit', array_merge($data, $judul));
    }

    public function update($id)
    {
        $model = new InterestModel();

        $data = [
            'name' => $this->request->getVar('name')
        ];

        $model->update($id, $data);

        return redirect()->to('admin/company-interest');
    }

    public function delete($id)
    {
        $model = new InterestModel();
        $model->delete($id);

        return redirect()->to('admin/company-interest');
    }
}
