<?php

namespace App\Controllers;

use App\Models\SectorModel;
use CodeIgniter\Controller;

class CompanySectorController extends Controller
{
    public function index()
    {
        $judul = [
            'title' => 'Sektor Perusahaan',
        ];
        $model = new SectorModel();
        $data['sectors'] = $model->getSectors();

        return view('admin/company_sector/index', array_merge($data, $judul));
    }

    public function create()
    {
        $judul = [
            'title' => 'Tambah Sektor Perusahaan',
        ];
        return view('admin/company_sector/create', $judul);
    }

    public function store()
    {
        $model = new SectorModel();

        $data = [
            'name' => $this->request->getVar('name')
        ];

        $model->save($data);

        return redirect()->to('admin/company-sector');
    }

    public function edit($id)
    {
        $judul = [
            'title' => 'Update Sektor Perusahaan',
        ];
        $model = new SectorModel();
        $data['sector'] = $model->find($id);

        return view('admin/company_sector/edit', array_merge($data, $judul));
    }

    public function update($id)
    {
        $model = new SectorModel();

        $data = [
            'name' => $this->request->getVar('name')
        ];

        $model->update($id, $data);

        return redirect()->to('admin/company-sector');
    }

    public function delete($id)
    {
        $model = new SectorModel();
        $model->delete($id);

        return redirect()->to('admin/company-sector');
    }
}
