<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // Cek apakah user tidak memiliki session 'loggedIn'
        if (!session()->get('loggedIn')) {
            // Get the current URL segment
            $segment = $request->uri->getSegment(1);

            // Redirect to the specific login page based on the segment
            switch ($segment) {
                case 'admin':
                    return redirect()->to('/admin/login');
                case 'company':
                    return redirect()->to('/company/login');
                default:
                    return redirect()->to('/login');
            }
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Metode after tidak diperlukan untuk filter ini
    }
}
