<?php

namespace App\Models;

use CodeIgniter\Model;
use Exception;

class ApplicantModel extends Model
{
    protected $baseUrl = 'http://localhost:3000/api/companies/';

    public function getApplicants($companyId, $vacancyId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function acceptApplicant($companyId, $vacancyId, $applicantId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->put($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants/' . $applicantId . '/accept');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function rejectApplicant($companyId, $vacancyId, $applicantId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->put($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants/' . $applicantId . '/reject');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }
}
