<?php

namespace App\Models;

use CodeIgniter\Model;
use Ramsey\Uuid\Uuid;

class InterestModel extends Model
{
    protected $table = 'interest';
    protected $primaryKey = 'id';
    protected $allowedFields = ['id', 'name'];

    protected $beforeInsert = ['generateUUID'];

    protected function generateUUID(array $data)
    {
        $data['data']['id'] = substr(Uuid::uuid4()->toString(), 0, 8);
        return $data;
    }

    public function getInterest()
    {
        return $this->orderBy('name', 'ASC')->findAll();
    }
}
