<?php

namespace App\Models;

use CodeIgniter\Model;
use Exception;
use Config\Services;

class VacancyModel extends Model
{
    protected $baseUrl = 'http://localhost:3000/api/companies/';

    public function getToken()
    {
        $session = session();
        return $session->get('token');
    }

    public function getVacancies($companyId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . $companyId . '/vacancies-descending');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }
    public function vacancyApplicant($companyId)
    {
        $client = \Config\Services::curlrequest();
        try {
            $response = $client->get($this->baseUrl . $companyId . '/applicants');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getCompany($companyId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . $companyId);
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getApplicants($companyId, $vacancyId)
    {
        $client = \Config\Services::curlrequest();
        try {
            $response = $client->get($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }



    // public function acceptApplicant($companyId, $vacancyId, $applicantId)
    // {
    //     $client = \Config\Services::curlrequest();
    //     try {
    //         $response = $client->put($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants/' . $applicantId . '/accept');
    //         return json_decode($response->getBody());
    //     } catch (Exception $e) {
    //         return false;
    //     }
    // }

    // public function rejectApplicant($companyId, $vacancyId, $applicantId)
    // {
    //     $client = \Config\Services::curlrequest();
    //     try {
    //         $response = $client->put($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants/' . $applicantId . '/reject');
    //         return json_decode($response->getBody());
    //     } catch (Exception $e) {
    //         return false;
    //     }
    // }
    public function acceptApplicant($companyId, $vacancyId, $applicantId, $notes)
    {
        $client = \Config\Services::curlrequest();
        try {
            $response = $client->put($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants/' . $applicantId . '/accept', [
                'form_params' => ['notes' => $notes]
            ]);
            return json_decode($response->getBody());
        } catch (Exception $e) {
            return false;
        }
    }

    public function rejectApplicant($companyId, $vacancyId, $applicantId, $notes)
    {
        $client = \Config\Services::curlrequest();
        try {
            $response = $client->put($this->baseUrl . $companyId . '/vacancies/' . $vacancyId . '/applicants/' . $applicantId . '/reject', [
                'form_params' => ['notes' => $notes]
            ]);
            return json_decode($response->getBody());
        } catch (Exception $e) {
            return false;
        }
    }

    public function sendWhatsAppNotification($phone, $message)
    {
        $httpClient = \Config\Services::curlrequest();

        try {
            // $response = $httpClient->request('POST', 'http://wa-api.arifrizqi.com/send-message', [
            //     'form_params' => [
            //         'session' => 'sesisatu',
            //         'to' => $phone,
            //         'text' => $message
            //     ]
            // ]);
            $response = $httpClient->request('POST', 'https://api.kuotavpn.com/api/create-message', [
                'form_params' => [
                    'appkey' => 'aeddea6e-6b28-43ac-bcfb-a6211783d45b',
                    'authkey' => 'mhuiWc2Aqhp12TB9tgqhVuGYeG6iT2iGSlFOsDzHel8f8KxXRY',
                    'to' => $phone,
                    'message' => $message
                ]
            ]);

            // Assuming the API returns a success indicator
            return json_decode($response->getBody())->success;
        } catch (Exception $e) {
            // Implement error handling (perhaps logging)
            return false;
        }
    }


    public function addVacancy($companyId, $data)
    {
        $client = \Config\Services::curlrequest();

        try {
            $headers = [
                'Authorization' => $this->getToken()
            ];

            $response = $client->post($this->baseUrl . $companyId . '/vacancies', [
                'headers' => $headers,
                'json' => $data
            ]);
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getVacancy($companyId, $vacancyId)
    {
        $client = Services::curlrequest();
        $response = $client->get($this->baseUrl . $companyId . '/vacancies/' . $vacancyId);
        return json_decode($response->getBody());
    }

    public function updateVacancy($companyId, $vacancyId, $data)
    {
        $client = Services::curlrequest();
        $response = $client->put($this->baseUrl . $companyId . '/vacancies/' . $vacancyId, [
            'json' => $data
        ]);
        return json_decode($response->getBody());
    }
}
