<?= $this->extend('admin/template/index'); ?>
<?= $this->section('content'); ?>

<?php if (session()->has('message')) : ?>
    <div class="alert alert-success">
        <?= session('message') ?>
    </div>
<?php endif; ?>
<?= $this->section('page-css'); ?>
<link href="<?= base_url('vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>

<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Minat Perusahaan</h6>
    </div>
    <div class="card-body">
        <a class="btn btn-primary mb-2" href="<?= site_url('/admin/company-interest/create') ?>">Tambah</a>
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Minat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Nama Minat</th>
                        <th>Aksi</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($interest) && !empty($interest)) : ?>
                        <?php foreach ($interest as $index => $inter) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($inter['name'], ENT_QUOTES, 'UTF-8') ?></td>
                                <td>
                                    <a class="btn btn-primary" href="<?= base_url('admin/company-interest/edit') ?>/<?= $inter['id']; ?>">Edit</a>
                                    <a class="btn btn-danger" href="javascript:void(0);" onclick="confirmDeleteInterest('<?= $inter['id']; ?>');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="7">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Page level plugins -->
<?= $this->section('page-js'); ?>
<script src="<?= base_url('vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('js/demo/datatables-demo.js') ?>"></script>

<?= $this->endSection(); ?>
<!-- <script>
    $(document).ready(function() {
        $('#applyStatusTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true
        });
    });
</script> -->

<?= $this->endSection(); ?>