<?= $this->extend('admin/template/index'); ?>
<?= $this->section('content'); ?>
<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Daftar Pencari Kerja</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Foto</th>
                        <th>Nama</th>
                        <th>Jenis Kelamin</th>
                        <th>Usia</th>
                        <th>Pendidikan</th>
                        <th>Minat</th>
                        <th>Kemampuan</th>
                        <th>Terdaftar Pada</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Foto</th>
                        <th>Nama</th>
                        <th>Jenis Kelamin</th>
                        <th>Usia</th>
                        <th>Pendidikan</th>
                        <th>Minat</th>
                        <th>Kemampuan</th>
                        <th>Terdaftar Pada</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($users) && !empty($users)) : ?>
                        <?php foreach ($users as $index => $user) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><img src="<?= htmlspecialchars($user->profile_photo_url, ENT_QUOTES, 'UTF-8') ?>" class="img-fluid" alt="Profile Photo" style="max-width: 80px;"></td>
                                <td><?= htmlspecialchars($user->full_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($user->gender, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($user->age, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($user->education, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($user->interest_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($user->skill_one_name, ENT_QUOTES, 'UTF-8') ?>, <?= htmlspecialchars($user->skill_two_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php
                                $dibuatPada = htmlspecialchars($user->created_at, ENT_QUOTES, 'UTF-8');
                                $dibuat = substr($dibuatPada, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($dibuat, ENT_QUOTES, 'UTF-8') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="7">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->section('page-js'); ?>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>
<?= $this->endSection(); ?>
<?= $this->endSection(); ?>