<?= $this->extend('admin/template/index'); ?>

<?= $this->section('content'); ?>

<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>

<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Verifikasi Perusahaan</h6>
    </div>
    <div class="card-body">
        <?php if (empty($data)) : ?>
            <p>No unverified company found.</p>
        <?php else : ?>
            <div class="table-responsive">
                <p class="alert alert-info">Cek kebenaran data perusahaan klik link berikut ini: <a href="https://ahu.go.id/pencarian/profil-pt" target="_blank">AHU Profil Perusahaan</a></p>
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Logo</th>
                            <th>Nama Perusahan</th>
                            <th>Akta Perusahan</th>
                            <th>Email</th>
                            <th>Alamat</th>
                            <th>No. Telp</th>
                            <th>Kota</th>
                            <th>Provinsi</th>
                            <th>Jumlah Pekerja</th>
                            <th>Sektor Perusahaan</th>
                            <th>Daftar Pada</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $index => $dataCompany) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><img src="<?= htmlspecialchars($dataCompany->logo, ENT_QUOTES, 'UTF-8') ?>" class="img-fluid" alt="Logo" style="max-width: 100px;"></td>
                                <td><?= htmlspecialchars($dataCompany->name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td>
                                    <?php if ($dataCompany->akta != null) : ?>
                                        <a href="<?= htmlspecialchars($dataCompany->akta, ENT_QUOTES, 'UTF-8') ?>" target="_blank"><i class="fas fa-eye"></i></a>
                                    <?php else : ?>
                                        Kosong
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($dataCompany->email, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataCompany->address, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataCompany->phone_number, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataCompany->city, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataCompany->province, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataCompany->employees, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataCompany->company_sector_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php
                                $deadline_time = htmlspecialchars($dataCompany->created_at, ENT_QUOTES, 'UTF-8');
                                $display_text = substr($deadline_time, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></td>
                                <td>
                                    <?php
                                    if (is_null($dataCompany->akta) || $dataCompany->akta == '') {
                                        echo "<span class='badge badge-danger'>Belum Lengkap</span>";
                                    } else {
                                        echo "<span class='badge badge-success'>Lengkap</span>";
                                    } ?>
                                </td>
                                <td>
                                    <div class="d-flex">
                                        <div class="m-2">
                                            <?php if ($dataCompany->is_verified == 'FALSE' || $dataCompany->is_verified == NULL) : ?>
                                                <a href="<?= site_url('admin/activate_company/' . $dataCompany->id) ?>" class="btn btn-success btn-sm">Accept</a>
                                            <?php else : ?>
                                                <a href="<?= site_url('admin/activate_company/' . $dataCompany->id) ?>" class="btn btn-secondary btn-lg btn-sm disabled" aria-disabled="true">Accept</a>
                                            <?php endif; ?>
                                        </div>
                                        <div class="m-2">
                                            <a href="<?= site_url('admin/disable_company/' . $dataCompany->id) ?>" class="btn btn-danger btn-sm">Reject</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->section('page-js'); ?>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>
<?= $this->endSection(); ?>

<?= $this->endSection(); ?>