<!DOCTYPE html>
<html>

<head>
    <title>Vacancies</title>
    <!-- Include Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <div class="container mt-4">
        <a href="<?= site_url('logout') ?>">Logout</a>
        <a href="<?= site_url('dashboard') ?>">Dashboard</a>
        <a href="<?= site_url('addvacancy') ?>">Add Vacancy</a>
        <h1>applicants</h1>
        <div class="row">
            <?php if (is_array($applicants) && !empty($applicants)) : ?>
                <?php foreach ($applicants as $applicant) : ?>
                    <div class="col-md-4 mb-4">
                        <div class="card">
                            <img src="<?= htmlspecialchars($applicant->company_logo, ENT_QUOTES, 'UTF-8') ?>" class="card-img-top" alt="Logo">
                            <div class="card-body">
                                <h5 class="card-title"><?= htmlspecialchars($applicant->placement_address, ENT_QUOTES, 'UTF-8') ?></h5>
                                <h6 class="card-subtitle mb-2 text-muted"><?= htmlspecialchars($applicant->sector_name, ENT_QUOTES, 'UTF-8') ?></h6>
                                <p class="card-text"><?= htmlspecialchars($applicant->description, ENT_QUOTES, 'UTF-8') ?></p>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><?= htmlspecialchars($applicant->skill_one_name, ENT_QUOTES, 'UTF-8') ?></li>
                                    <li class="list-group-item"><?= htmlspecialchars($applicant->skill_two_name, ENT_QUOTES, 'UTF-8') ?></li>
                                    <li class="list-group-item"><?= htmlspecialchars($applicant->interest_name, ENT_QUOTES, 'UTF-8') ?></li>
                                    <li class="list-group-item"><?= htmlspecialchars($applicant->total_applicants, ENT_QUOTES, 'UTF-8') ?></li>
                                    <li class="list-group-item"><?= $applicant->job_type == 1 ? "Part Time" : "Full Time" ?></li>
                                    <li class="list-group-item"><?= htmlspecialchars($applicant->deadline_time, ENT_QUOTES, 'UTF-8') ?></li>
                                </ul>
                                <!-- Add button to view applicants -->
                                <a href="<?= site_url('vacancies/applicants/' . $applicant->id) ?>" class="btn btn-primary">View Applicants</a>
                                <!-- Add edit button -->
                                <a href="<?= site_url('vacancy/edit/' . $applicant->id) ?>" class="btn btn-warning">Edit</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else : ?>
                <p>No applicants available.</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Optional JavaScript and jQuery for Bootstrap -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>