<?= $this->extend('template/index'); ?>
<?= $this->section('content'); ?>

<?php if (session()->has('message')) : ?>
    <div class="alert alert-success">
        <?= session('message') ?>
    </div>
<?php endif; ?>
<?= $this->section('page-css'); ?>
<link href="<?= base_url('vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>

<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Status Lamaran</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Penempatan</th>
                        <th>Perusahaan</th>
                        <th>Waktu Melamar</th>
                        <th>Status</th>
                        <th>Catatan Perusahaan</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Penempatan</th>
                        <th>Perusahaan</th>
                        <th>Waktu Melamar</th>
                        <th>Status</th>
                        <th>Catatan Perusahaan</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($data) && !empty($data)) : ?>
                        <?php foreach ($data as $index => $applyStatus) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($applyStatus->vacancy_placement_address, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applyStatus->company_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php
                                $deadline_time = htmlspecialchars($applyStatus->applied_at, ENT_QUOTES, 'UTF-8');
                                $display_text = substr($deadline_time, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></td>
                                <td>
                                    <?php if ($applyStatus->status == 'Accepted') : ?>
                                        <span class="badge badge-success">
                                            <?= htmlspecialchars($applyStatus->status, ENT_QUOTES, 'UTF-8') ?>
                                        </span>
                                    <?php elseif ($applyStatus->status == 'Pending') : ?>
                                        <span class="badge badge-warning">
                                            <?= htmlspecialchars($applyStatus->status, ENT_QUOTES, 'UTF-8') ?>
                                        </span>
                                    <?php else : ?>
                                        <span class="badge badge-danger">
                                            <?= htmlspecialchars($applyStatus->status, ENT_QUOTES, 'UTF-8') ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td><?= $applyStatus->notes !== null ? htmlspecialchars($applyStatus->notes, ENT_QUOTES, 'UTF-8') : "Belum ada catatan" ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="7">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Page level plugins -->
<?= $this->section('page-js'); ?>
<script src="<?= base_url('vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('js/demo/datatables-demo.js') ?>"></script>

<?= $this->endSection(); ?>
<!-- <script>
    $(document).ready(function() {
        $('#applyStatusTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true
        });
    });
</script> -->

<?= $this->endSection(); ?>