<?= $this->extend('company/template/index'); ?>
<?= $this->section('content'); ?>
<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>
<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Status Lamaran</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>Alamat</th>
                        <th>Jenis Kelamin</th>
                        <th>CV</th>
                        <th>Tanggal Melamar</th>
                        <th>Status</th>
                        <th>Catatan Perusahaan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>Alamat</th>
                        <th>Jenis Kelamin</th>
                        <th>CV</th>
                        <th>Tanggal Melamar</th>
                        <th>Status</th>
                        <th>Catatan Perusahaan</th>
                        <th>Aksi</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($applicants) && !empty($applicants)) : ?>
                        <?php foreach ($applicants as $index => $applicant) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($applicant->full_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->email, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->address, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->gender, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><a href="<?= htmlspecialchars($applicant->cv, ENT_QUOTES, 'UTF-8') ?>" target="_blank">Lihat CV</a></td>
                                <?php
                                $deadline_time = htmlspecialchars($applicant->applied_at, ENT_QUOTES, 'UTF-8');
                                $display_text = substr($deadline_time, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></td>
                                <td>
                                    <?php if ($applicant->status == 'Accepted') : ?>
                                        <span class="badge badge-success"><?= htmlspecialchars($applicant->status, ENT_QUOTES, 'UTF-8') ?></span>
                                    <?php elseif ($applicant->status == 'Pending') : ?>
                                        <span class="badge badge-warning"><?= htmlspecialchars($applicant->status, ENT_QUOTES, 'UTF-8') ?></span>
                                    <?php else : ?>
                                        <span class="badge badge-danger"><?= htmlspecialchars($applicant->status, ENT_QUOTES, 'UTF-8') ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?= $applicant->notes !== null ? htmlspecialchars($applicant->notes, ENT_QUOTES, 'UTF-8') : "Belum ada catatan" ?></td>
                                <td>
                                    <?php if ($applicant->status == 'Pending') : ?>
                                        <form action="<?= site_url('company/vacancies/handleApplicant/' . $companyId . '/' . $vacancyId . '/' . $applicant->id) ?>" method="post">
                                            <div class="form-group">
                                                <label for="notes">Notes:</label>
                                                <input type="text" class="form-control mb-2" id="notes" name="notes" required>
                                                <input type="hidden" name="applicant_phone_number" value="<?= htmlspecialchars($applicant->phone_number, ENT_QUOTES, 'UTF-8') ?>">
                                            </div>
                                            <div class="btn-group" role="group">
                                                <button type="submit" name="action" value="accept" class="btn btn-success mr-2">Accept</button>
                                                <button type="submit" name="action" value="reject" class="btn btn-danger">Reject</button>
                                            </div>
                                        </form>
                                    <?php elseif ($applicant->status == 'Accepted') : ?>
                                        <p class="card-text text-success">Diterima</p>
                                    <?php elseif ($applicant->status == 'Rejected') : ?>
                                        <p class="card-text text-danger">Ditolak</p>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="10">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Page level plugins -->
<?= $this->section('page-js'); ?>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>

<?= $this->endSection(); ?>
<?= $this->endSection(); ?>