</html>
<?= $this->extend('company/template/index'); ?>
<?= $this->section('content'); ?>
<h1>Profil</h1>
<?php if (session()->has('message')) : ?>
    <div class="alert alert-success">
        <?= session()->get('message') ?>
    </div>
<?php endif; ?>

<?php if (session()->has('error')) : ?>
    <div class="alert alert-success">
        <?= session()->get('error') ?>
    </div>
<?php endif; ?>
<div class="row">
    <div class="col-xl-4">
        <!-- Profile picture card-->
        <div class="card mb-4 mb-xl-0">
            <div class="card-header">Profile Picture</div>
            <div class="card-body text-center">
                <!-- Profile picture image-->
                <img class="img-account-profile rounded-circle mb-2" src="<?= $company->logo ?>" alt="" width="200px" height="200px" />
                <!-- Profile picture help block-->
                <div class="small font-italic text-muted mb-4">JPG or PNG no larger than 5 MB</div>
                <!-- Profile picture upload button-->
                <form id="uploadForm" action="<?= site_url('company/upload-logo/' . $company->id) ?>" method="post" enctype="multipart/form-data" style="display: none;">
                    <input type="file" name="logo" id="profile_photo_input" class="form-control">
                </form>
                <button class="btn btn-primary" type="button" id="uploadButton">Upload new image</button>
            </div>
        </div>
        <!-- CV card -->
        <div class="card mb-4 mb-xl-0 mt-4">
            <div class="card-header">Akta</div>
            <div class="card-body text-center">
                <!-- Embed PDF CV-->
                <embed src="<?= $company->akta ?>" type="application/pdf" width="100%" height="200px" />
                <!-- akta help block-->
                <div class="small text-muted mb-4"><a href="<?= $company->akta ?>">Unduh</a></div>
                <!-- CV upload button-->
                <form id="uploadFormAkta" action="<?= site_url('company/upload-akta/' . $company->id) ?>" method="post" enctype="multipart/form-data" style="display: none;">
                    <input type="file" name="akta" id="inputakta" class="form-control">
                </form>
                <button class="btn btn-primary" type="button" id="uploadButtonAkta">Upload new Akta</button>
            </div>
        </div>
    </div>

    <div class="col-xl-8">
        <!-- Account details card-->
        <div class="card mb-4">
            <div class="card-header">Account Details</div>
            <div class="card-body">
                <form action="<?= site_url('company/update/' . $company->id) ?>" method="post">
                    <!-- Form Row-->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (first name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="name">Nama</label>
                            <input class="form-control" type="text" name="name" value="<?= $company->name ?>" />
                        </div>
                        <!-- Form Group (last name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="email">Surel</label>
                            <input class="form-control" type="email" name="email" value="<?= $company->email ?>" />
                        </div>
                    </div>
                    <!-- Form Row        -->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (organization name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="id_sector">Sektor Perusahaan</label>
                            <select class="form-control" name="id_sector" id="id_sector">
                                <?php foreach ($sector as $interes) : ?>
                                    <option value="<?= $interes['id'] ?>" <?= $company->sector_name == $interes['name'] ? 'selected' : '' ?>><?= $interes['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="small mb-1" for="city">Kota</label>
                            <input class="form-control" type="text" name="city" value="<?= $company->city ?>" />
                        </div>
                    </div>
                    <!-- Form Row        -->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (organization name)-->

                        <!-- Form Group (location)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="province">Provinsi</label>
                            <input class="form-control" id="province" type="text" name="province" value="<?= $company->province ?>" />
                        </div>
                        <div class="col-md-6">
                            <label class="small mb-1" for="employees">Jumlah Karyawan</label>
                            <input class="form-control" id="employees" type="number" name="employees" value="<?= $company->employees ?>" />
                        </div>
                    </div>
                    <div class="row gx-3 mb-3">
                        <div class="col-md-6">
                            <label class="small mb-1" for="phone_number">Telepon</label>
                            <input class="form-control" id="phone_number" type="text" name="phone_number" value="<?= $company->phone_number ?>" />
                        </div>
                    </div>
                    <!-- Form Group (email address)-->
                    <div class="mb-3">
                        <label class="small mb-1" for="address">Alamat</label>
                        <textarea class="form-control" id="address" name="address"><?= $company->address ?></textarea>
                    </div>
                    <div class="d-flex">
                        <!-- <button class="btn btn-primary d-flex justify-content-end" type="submit">Simpan</button> -->
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                    <!-- Save changes button-->
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->section('page-js'); ?>
<script>
    $(document).ready(function() {
        // Trigger input file click when upload button is clicked
        $('#uploadButton').on('click', function() {
            $('#profile_photo_input').click();
        });

        // Submit the form when a file is selected
        $('#profile_photo_input').on('change', function() {
            if ($(this).val()) {
                var formData = new FormData($('#uploadForm')[0]);
                $.ajax({
                    url: $('#uploadForm').attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $("#loadnya").show();
                    },
                    success: function(response) {
                        $("#loadnya").hide();
                        if (response.success) {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        $("#loadnya").hide();
                        Swal.fire('Error!', 'Terjadi kesalahan', 'error');
                    }
                });
            }
        });
        $('#uploadButtonAkta').on('click', function() {
            $('#inputakta').click();
        });

        // Submit the form when a CV file is selected
        $('#inputakta').on('change', function() {
            if ($(this).val()) {
                var formData = new FormData($('#uploadFormAkta')[0]);
                $.ajax({
                    url: $('#uploadFormAkta').attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $("#loadnya").show();
                    },
                    success: function(response) {
                        $("#loadnya").hide();
                        if (response.success) {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            // Swal.fire('Gagal!', response.message, 'error');
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        $("#loadnya").hide();
                        Swal.fire('Error!', 'Terjadi kesalahan', 'error');
                    }
                });
            }
        });
    });
</script>
<?= $this->endSection(); ?>
<?= $this->endSection(); ?>