<?= $this->extend('company/template/index'); ?>
<?= $this->section('content'); ?>
<?php if (session()->getFlashdata('hapus')) : ?>
    <div class="alert alert-danger" role="alert">
        <?= session()->getFlashdata('hapus') ?>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('message')) : ?>
    <div class="alert alert-danger" role="alert">
        <?= session()->getFlashdata('message') ?>
    </div>
<?php endif; ?>
<?php if (session()->getFlashdata('success')) : ?>
    <div class="alert alert-success" role="alert">
        <?= session()->getFlashdata('success') ?>
    </div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')) : ?>
    <div class="alert alert-danger" role="alert">
        <?= session()->getFlashdata('error') ?>
    </div>
<?php endif; ?>
<?php if (session()->getFlashdata('berhasilEdit')) : ?>
    <div class="alert alert-success" role="alert">
        <?= session()->getFlashdata('berhasilEdit') ?>
    </div>
<?php endif; ?>

<?php

if ($companies->is_verified == null) {
    echo "<div class='alert alert-danger'>Akun belum diverifikasi karena dokumen Akta belum dilengkapi, silakan lengkapi dokumen anda di menu profil!</div>";
} elseif ($companies->is_verified == 'FALSE') {
    echo "<div class='alert alert-danger'>Akun ditolak karena dokumen Akta belum tidak sah, silakan perbaiki dokumen anda di menu profil!</div>";
}
?>

<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>
<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Lowongan Saya</h6>
    </div>
    <div class="card-body">

        <a class="btn btn-primary mb-2" href="<?= site_url('/company/addvacancy') ?>">Tambah</a>
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Penempatan</th>
                        <th>Sektor</th>
                        <th>Minat</th>
                        <th>Jenis</th>
                        <th>Tanggal Dibuat</th>
                        <th>Tanggal Berakhir</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Penempatan</th>
                        <th>Sektor</th>
                        <th>Minat</th>
                        <th>Jenis</th>
                        <th>Tanggal Dibuat</th>
                        <th>Tanggal Berakhir</th>
                        <th>Aksi</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($vacancies) && !empty($vacancies)) : ?>
                        <?php foreach ($vacancies as $index => $vacancy) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($vacancy->placement_address, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($vacancy->sector_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($vacancy->interest_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php if ($vacancy->job_type == 1) {
                                    $job = 'Full Time';
                                } elseif ($vacancy->job_type == 2) {
                                    $job = 'Part Time';
                                } else {
                                    $job = 'Remote';
                                }
                                ?>
                                <td><?= htmlspecialchars($job, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php
                                $deadline_time = htmlspecialchars($vacancy->deadline_time, ENT_QUOTES, 'UTF-8');
                                $created_time = htmlspecialchars($vacancy->created_at, ENT_QUOTES, 'UTF-8');
                                $display_text = substr($deadline_time, 0, 10);
                                $dibuat = substr($created_time, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($dibuat, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></td>
                                <td class="d-flex">
                                    <div class="mr-2">
                                        <a href="<?= site_url('company/vacancy/edit/' . $vacancy->id) ?>" class="btn btn-warning btn-sm"><i class="fa fa-edit"></i></a>
                                    </div>
                                    <div>
                                        <a href="javascript:void(0);" onclick="deleteLowongan('<?= $vacancy->id ?>')" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                        <!-- <a href="<?= site_url('company/vacancy/delete/' . $vacancy->id) ?>" class="btn btn-warning btn-sm"><i class="fa fa-trash"></i></a> -->
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="10">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Page level plugins -->
<?= $this->section('page-js'); ?>
<script>
    function deleteLowongan(vacancyId) {
        Swal.fire({
            title: 'Yakin ingin hapus data ini?',
            text: "Anda tidak akan dapat mengembalikannya!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "<?= site_url('company/vacancy/delete/') ?>" + vacancyId;
            }
        });
    }
</script>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>
<?= $this->endSection(); ?>
<?= $this->endSection(); ?>