<!DOCTYPE html>
<html>

<head>
    <title>Vacancies</title>
    <!-- Include Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">
</head>


<body>
    <div class="container mt-4">
        <a href="<?= site_url('logout') ?>">Logout</a>
        <a href="<?= site_url('dashboard') ?>">Dashboard</a>
        <h1>Vacancies</h1>
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="card">
                    <img src="<?= htmlspecialchars($company_logo, ENT_QUOTES, 'UTF-8') ?>" class="card-img-top" alt="Logo">
                    <div class="card-body">
                        <h5 class="card-title"><?= htmlspecialchars($placement_address, ENT_QUOTES, 'UTF-8') ?></h5>
                        <h6 class="card-subtitle mb-2 text-muted"><?= htmlspecialchars($sector_name, ENT_QUOTES, 'UTF-8') ?></h6>
                        <p class="card-text"><?= htmlspecialchars($description, ENT_QUOTES, 'UTF-8') ?></p>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item"><?= htmlspecialchars($skill_one_name, ENT_QUOTES, 'UTF-8') ?></li>
                            <li class="list-group-item"><?= htmlspecialchars($skill_one_name, ENT_QUOTES, 'UTF-8') ?></li>
                            <li class="list-group-item"><?= htmlspecialchars($skill_two_name, ENT_QUOTES, 'UTF-8') ?></li>
                            <li class="list-group-item"><?= htmlspecialchars($interest_name, ENT_QUOTES, 'UTF-8') ?></li>
                            <li class="list-group-item"><?= $job_type == 1 ? "Part Time" : "Full Time" ?></li>
                            <li class="list-group-item"><?= htmlspecialchars($deadline_time, ENT_QUOTES, 'UTF-8') ?></li>
                        </ul>
                        <div class="card-footer">
                            <?php if (isset($applicationStatus)) : ?>
                                <?php if ($applicationStatus === 'Pending') : ?>
                                    <button class="btn btn-secondary" disabled>Pending</button>
                                <?php elseif ($applicationStatus === 'Accepted') : ?>
                                    <button class="btn btn-success" disabled>Accepted</button>
                                <?php elseif ($applicationStatus === 'Rejected') : ?>
                                    <button class="btn btn-danger" disabled>Rejected</button>
                                <?php else : ?>
                                    <a href="<?= site_url('apply/' . $userId . '/' . $id) ?>" class="btn btn-primary">Apply for Job</a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Optional JavaScript and jQuery for Bootstrap -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>