<?= $this->extend('template/index'); ?>
<?= $this->section('content'); ?>

<?php if (session()->has('error')) : ?>
    <div class="alert alert-danger">
        <?= session('error') ?>
    </div>
<?php endif; ?>

<h1 class="h3 mb-4 text-primary">Vacancies</h1>
<div class="row">
    <div class="col-lg-8">
        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title"><?= htmlspecialchars($vacancy->placement_address, ENT_QUOTES, 'UTF-8') ?></h5>
                <h6 class="card-subtitle mb-2 text-muted"><?= htmlspecialchars($vacancy->sector_name, ENT_QUOTES, 'UTF-8') ?></h6>
                <h6 class="card-subtitle mb-2 text-muted mt-4">Deskripsi: <?= htmlspecialchars($vacancy->description, ENT_QUOTES, 'UTF-8') ?></h6>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">Kemampuan Satu: <?= htmlspecialchars($vacancy->skill_one_name, ENT_QUOTES, 'UTF-8') ?></li>
                    <li class="list-group-item">Kemampuan Dua: <?= htmlspecialchars($vacancy->skill_two_name, ENT_QUOTES, 'UTF-8') ?></li>
                    <li class="list-group-item">Minat: <?= htmlspecialchars($vacancy->interest_name, ENT_QUOTES, 'UTF-8') ?></li>
                    <li class="list-group-item">Gaji: Rp. <?= htmlspecialchars($vacancy->salary, ENT_QUOTES, 'UTF-8') ?></li>
                    <li class="list-group-item">Jenis Pekerjaan:
                        <?php
                        if ($vacancy->job_type == 1) {
                            echo "Full-time";
                        } elseif ($vacancy->job_type == 2) {
                            echo "Part-time";
                        } elseif ($vacancy->job_type == 3) {
                            echo "Remote";
                        } else {
                            echo "Unknown";
                        }
                        ?>
                    </li>
                    <?php
                    $deadline_time = htmlspecialchars($vacancy->deadline_time, ENT_QUOTES, 'UTF-8');
                    $display_text = substr($deadline_time, 0, 10);
                    ?>
                    <li class="list-group-item">Tutup Pada: <?= $display_text ?></li>
                </ul>
                <div class="card-footer">
                    <?php
                    // Pengecekan apakah lowongan sudah tutup
                    $deadline = new \DateTime($vacancy->deadline_time);
                    $today = new \DateTime();
                    ?>
                    <?php if ($deadline < $today) : ?>
                        <button class="btn btn-secondary" disabled>Ditutup</button>
                    <?php elseif (isset($applicationStatus)) : ?>
                        <?php if ($applicationStatus === 'Pending') : ?>
                            <button class="btn btn-secondary" disabled>Pending</button>
                        <?php elseif ($applicationStatus === 'Accepted') : ?>
                            <button class="btn btn-success" disabled>Accepted</button>
                        <?php elseif ($applicationStatus === 'Rejected') : ?>
                            <button class="btn btn-danger" disabled>Rejected</button>
                        <?php else : ?>
                            <button class="btn btn-primary" onclick="confirmApply('<?= $userId ?>', '<?= $vacancy->id ?>');">Apply for Job</button>
                        <?php endif; ?>
                    <?php else : ?>
                        <button class="btn btn-primary" onclick="confirmApply('<?= $userId ?>', '<?= $vacancy->id ?>');">Apply for Job</button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card company-card mb-4">
            <img src="<?= htmlspecialchars($company->logo, ENT_QUOTES, 'UTF-8') ?>" class="card-img-top" alt="Company Logo">
            <div class="card-body">
                <h5 class="card-title"><?= htmlspecialchars($company->name, ENT_QUOTES, 'UTF-8') ?></h5>
                <p class="card-text">Alamat: <?= htmlspecialchars($company->address, ENT_QUOTES, 'UTF-8') ?></p>
                <p class="card-text">Kota: <?= htmlspecialchars($company->city, ENT_QUOTES, 'UTF-8') ?></p>
                <p class="card-text">Provinsi: <?= htmlspecialchars($company->province, ENT_QUOTES, 'UTF-8') ?></p>
                <p class="card-text">Sector Bisnis: <?= htmlspecialchars($company->sector_name, ENT_QUOTES, 'UTF-8') ?></p>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>