<?= $this->extend('template/index'); ?>
<?= $this->section('content'); ?>
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-primary">Rekomendasi Pekerjaan</h1>
</div>

<div class="row">
    <div class="col-xl-8 col-lg-7">
        <div class="row">
            <?php if ($filteredVacancies) : ?>
                <?php foreach ($filteredVacancies as $vacancy) : ?>
                    <div class="col-xl-6 col-md-6 mb-4">
                        <a href="<?= site_url('detail_vacancy_with_company/' . $vacancy->id) ?>" class="text-decoration-none">
                            <div class="card shadow h-100 border-left-primary">
                                <div class="card-body d-flex flex-column">
                                    <div class="d-flex align-items-center mb-3">
                                        <img src="<?= htmlspecialchars($vacancy->company_logo, ENT_QUOTES, 'UTF-8') ?>" class="company-logo mr-3" alt="Company Logo">
                                        <div>
                                            <h5 class="card-title text-primary mb-1"><?= htmlspecialchars($vacancy->placement_address, ENT_QUOTES, 'UTF-8') ?></h5>
                                            <h6 class="card-subtitle mb-2 text-muted"><?= htmlspecialchars($vacancy->sector_name, ENT_QUOTES, 'UTF-8') ?></h6>
                                            <h6 class="card-subtitle mb-2 text-muted">
                                                <?php
                                                if ($vacancy->job_type == 1) {
                                                    echo "Full-time";
                                                } elseif ($vacancy->job_type == 2) {
                                                    echo "Part-time";
                                                } elseif ($vacancy->job_type == 3) {
                                                    echo "Remote";
                                                } else {
                                                    echo "Unknown";
                                                }
                                                ?>
                                            </h6>
                                        </div>
                                    </div>
                                    <p class="card-text text-dark mb-3 flex-grow-1"><?= htmlspecialchars($vacancy->description, ENT_QUOTES, 'UTF-8') ?></p>
                                    <div class="mt-auto">
                                        <div class="mb-2">
                                            <span class="badge badge-primary"><?= htmlspecialchars($vacancy->skill_one_name, ENT_QUOTES, 'UTF-8') ?></span>
                                            <span class="badge badge-primary"><?= htmlspecialchars($vacancy->skill_two_name, ENT_QUOTES, 'UTF-8') ?></span>
                                            <span class="badge badge-primary"><?= htmlspecialchars($vacancy->interest_name, ENT_QUOTES, 'UTF-8') ?></span>
                                        </div>
                                        <?php
                                        // Ubah deadline_time jika melewati tanggal hari ini
                                        $deadline = new \DateTime($vacancy->deadline_time);
                                        $today = new \DateTime();
                                        if ($deadline < $today) {
                                            $display_text = 'Ditutup';
                                        } else {
                                            $display_text = substr($vacancy->deadline_time, 0, 10);
                                        }
                                        ?>
                                        <p class="card-text mt-3"><strong>Tutup Pada:</strong> <span class="text-danger"><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></span></p>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            <?php else : ?>
                <div class="col-12">
                    <div class="alert alert-warning" role="alert">
                        No vacancies available.
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="col-xl-4 col-lg-5 mb-4">
        <div class="position-sticky" style="top: 20px;">
            <div class="card shadow h-100 border-left-primary">
                <div class="card-body">
                    <h5 class="card-title text-primary mb-1">10 Rekomendasi Pekerjaan yang Mungkin Cocok Denganmu</h5>
                    <?php if (isset($recommendations)) : ?>
                        <ul class="list-group list-group-flush">
                            <?php foreach ($recommendations as $job) : ?>
                                <li class="list-group-item"><?= esc($job); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else : ?>
                        <p>No job recommendations available.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>