<?= $this->extend('template/index'); ?>
<?= $this->section('content'); ?>
<div class="container mt-4">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <a href="<?= site_url('logout') ?>" class="btn btn-outline-primary">Logout</a>
        <a href="<?= site_url('dashboard') ?>" class="btn btn-outline-primary">Dashboard</a>
    </div>
    <h1 class="h3 mb-4 text-primary">Vacancies</h1>
    <div class="row">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title"><?= htmlspecialchars($vacancy->placement_address, ENT_QUOTES, 'UTF-8') ?></h5>
                    <h6 class="card-subtitle mb-2 text-muted"><?= htmlspecialchars($vacancy->sector_name, ENT_QUOTES, 'UTF-8') ?></h6>

                    <ul class="list-group list-group-flush">
                        <li class="list-group-item"><?= htmlspecialchars($vacancy->skill_one_name, ENT_QUOTES, 'UTF-8') ?></li>
                        <li class="list-group-item"><?= htmlspecialchars($vacancy->skill_two_name, ENT_QUOTES, 'UTF-8') ?></li>
                        <li class="list-group-item"><?= htmlspecialchars($vacancy->interest_name, ENT_QUOTES, 'UTF-8') ?></li>
                        <li class="list-group-item"><?= $vacancy->job_type == 1 ? "Part Time" : "Full Time" ?></li>
                        <li class="list-group-item"><?= htmlspecialchars($vacancy->deadline_time, ENT_QUOTES, 'UTF-8') ?></li>
                    </ul>
                    <div class="card-footer">
                        <?php if (isset($applicationStatus)) : ?>
                            <?php if ($applicationStatus === 'Pending') : ?>
                                <button class="btn btn-secondary" disabled>Pending</button>
                            <?php elseif ($applicationStatus === 'Accepted') : ?>
                                <button class="btn btn-success" disabled>Accepted</button>
                            <?php elseif ($applicationStatus === 'Rejected') : ?>
                                <button class="btn btn-danger" disabled>Rejected</button>
                            <?php else : ?>
                                <a href="<?= site_url('apply/' . $userId . '/' . $vacancy->id) ?>" class="btn btn-primary">Apply for Job</a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <h2>Company Details</h2>
            <div class="card company-card mb-4">
                <img src="<?= htmlspecialchars($company->logo, ENT_QUOTES, 'UTF-8') ?>" class="card-img-top" alt="Company Logo">
                <div class="card-body">
                    <h5 class="card-title"><?= htmlspecialchars($company->name, ENT_QUOTES, 'UTF-8') ?></h5>
                    <p class="card-text"><?= htmlspecialchars($company->address, ENT_QUOTES, 'UTF-8') ?></p>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>