<?= $this->extend('template/index'); ?>
<?= $this->section('content'); ?>

<h1>Edit user</h1>
<?php if (session()->has('pesan')) : ?>
    <div class="alert alert-success">
        <?= session()->get('pesan') ?>
    </div>
<?php endif; ?>

<?php if (session()->has('error')) : ?>
    <div class="alert alert-danger">
        <?= session()->get('error') ?>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-xl-4">
        <!-- Profile picture card-->
        <div class="card mb-4 mb-xl-0">
            <div class="card-header">Profile Picture</div>
            <div class="card-body text-center">
                <!-- Profile picture image-->
                <img class="img-account-profile rounded-circle mb-2" src="<?= $user->profile_photo_url ?>" alt="" width="200px" height="200px" />
                <!-- Profile picture help block-->
                <div class="small font-italic text-muted mb-4">JPG or PNG no larger than 5 MB</div>
                <!-- Profile picture upload button-->
                <form id="uploadForm" action="<?= site_url('user/upload-logo/' . $user->id) ?>" method="post" enctype="multipart/form-data" style="display: none;">
                    <input type="file" name="profile_photo_url" id="profile_photo_input" class="form-control">
                </form>
                <button class="btn btn-primary" type="button" id="uploadButton">Upload new image</button>
            </div>
        </div>

        <!-- CV card -->
        <div class="card mb-4 mb-xl-0 mt-4">
            <div class="card-header">CV</div>
            <div class="card-body text-center">
                <!-- Embed PDF CV-->
                <embed src="<?= $user->cv ?>" type="application/pdf" width="100%" height="200px" />
                <!-- CV help block-->
                <div class="small text-muted mb-4"><a href="<?= $user->cv ?>">Unduh</a></div>
                <!-- CV upload button-->
                <form id="uploadFormCV" action="<?= site_url('user/upload-cv/' . $user->id) ?>" method="post" enctype="multipart/form-data" style="display: none;">
                    <input type="file" name="cv" id="inputcv" class="form-control">
                </form>
                <button class="btn btn-primary" type="button" id="uploadButtonCV">Upload new CV</button>
            </div>
        </div>
    </div>

    <div class="col-xl-8">
        <!-- Account details card-->
        <div class="card mb-4">
            <div class="card-header">Account Details</div>
            <div class="card-body">
                <form action="<?= site_url('user/update/' . $user->id) ?>" method="post">
                    <!-- Form Row-->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (first name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="full_name">Nama</label>
                            <input class="form-control" type="text" name="full_name" value="<?= $user->full_name ?>" />
                        </div>
                        <!-- Form Group (last name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="email">Surel</label>
                            <input class="form-control" type="email" name="email" value="<?= $user->email ?>" />
                        </div>
                    </div>
                    <!-- Form Row        -->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (organization name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="skill_one">Kemampuan Satu</label>
                            <select class="form-control" name="skill_one" id="skill_one">
                                <?php foreach ($skill as $sk) : ?>
                                    <option value="<?= $sk['id'] ?>" <?= $user->skill_one_name == $sk['name'] ? 'selected' : '' ?>><?= $sk['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <!-- Form Group (location)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="skill_two">Kemampuan Dua</label>
                            <select class="form-control" name="skill_two" id="skill_two">
                                <?php foreach ($skill as $sk) : ?>
                                    <option value="<?= $sk['id'] ?>" <?= $user->skill_two_name == $sk['name'] ? 'selected' : '' ?>><?= $sk['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <!-- Form Row        -->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (organization name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="id_interest">Minat</label>
                            <select class="form-control" name="id_interest" id="id_interest">
                                <?php foreach ($interest as $interes) : ?>
                                    <option value="<?= $interes['id'] ?>" <?= $user->interest_name == $interes['name'] ? 'selected' : '' ?>><?= $interes['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <!-- Form Group (location)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="phone_number">No Telepon</label>
                            <input class="form-control" id="phone_number" type="tel" name="phone_number" value="<?= $user->phone_number ?>" />
                        </div>
                    </div>

                    <div class="row gx-3 mb-3">
                        <!-- Form Group (first name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="age">Usia</label>
                            <input class="form-control" type="number" name="age" value="<?= $user->age ?>" />
                        </div>
                        <!-- Form Group (last name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="education">Jenjang Pendidikan</label>
                            <input class="form-control" type="text" name="education" value="<?= $user->education ?>" />
                        </div>
                    </div>
                    <!-- Form Group (email address)-->
                    <div class="mb-3">
                        <label class="small mb-1" for="address">Alamat</label>
                        <textarea class="form-control" id="address" name="address"><?= $user->address ?></textarea>
                    </div>
                    <div class="d-flex">
                        <button class="btn btn-primary d-flex justify-content-end" type="submit">Simpan</button>
                    </div>
                    <!-- Save changes button-->
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->section('page-js'); ?>
<script>
    $(document).ready(function() {
        // Trigger input file click when upload button is clicked
        $('#uploadButton').on('click', function() {
            $('#profile_photo_input').click();
        });

        // Submit the form when a file is selected
        $('#profile_photo_input').on('change', function() {
            if ($(this).val()) {
                var formData = new FormData($('#uploadForm')[0]);
                $.ajax({
                    url: $('#uploadForm').attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $("#loadnya").show();
                    },
                    success: function(response) {
                        $("#loadnya").hide();
                        if (response.success) {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            // Swal.fire('Gagal!', response.message, 'error');
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        $("#loadnya").hide();
                        Swal.fire('Error!', 'Terjadi kesalahan', 'error');
                    }
                });
            }
        });

        // Trigger input file click when upload CV button is clicked
        $('#uploadButtonCV').on('click', function() {
            $('#inputcv').click();
        });

        // Submit the form when a CV file is selected
        $('#inputcv').on('change', function() {
            if ($(this).val()) {
                var formData = new FormData($('#uploadFormCV')[0]);
                $.ajax({
                    url: $('#uploadFormCV').attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $("#loadnya").show();
                    },
                    success: function(response) {
                        $("#loadnya").hide();
                        if (response.success) {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            // Swal.fire('Gagal!', response.message, 'error');
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        $("#loadnya").hide();
                        Swal.fire('Error!', 'Terjadi kesalahan', 'error');
                    }
                });
            }
        });
    });
</script>
<?= $this->endSection(); ?>
<?= $this->endSection(); ?>